package gov.va.vinci.dart.rule;

import gov.va.vinci.dart.biz.DartRequest;
import gov.va.vinci.dart.biz.DataSource;
import gov.va.vinci.dart.biz.DocumentTemplate;
import gov.va.vinci.dart.biz.Group;
import gov.va.vinci.dart.biz.Location;
import gov.va.vinci.dart.biz.Participant;
import gov.va.vinci.dart.biz.Request;

/**
 * The Class VitalStatusScrambledDocumentRuleEvaluator.
 */
public class VitalStatusScrambledDocumentRuleEvaluator extends AbstractDocumentRuleEvaluator {

    @Override
    public boolean isRequired(Request request, DataSource dataSource, DocumentTemplate documentTemplate, Location location,
            final boolean isIndependentOnly) {

        if (request == null) {
            return false;
        }

        Location primarySite = request.getPrimaryLocation();
        if (isDartRequest(request)) {

            DartRequest dartRequest = (DartRequest) request;

            // doc 2 is required of all sites if the HIPAA waiver is true
            if (documentTemplate.getName().startsWith("IRB Approval of Waiver of HIPAA") && dartRequest.isHipaaWaiver()) {
                return true;
            }

            // doc 3 is required of all sites
            if (documentTemplate.getName().startsWith("Research and Development (RD) Committee Approval")) {
                return true;
            }

            // doc 4 is required of all sites
            if (documentTemplate.getName().startsWith("Research Study Institutional Review Board (IRB) Approval")) {
                return true;
            }

            if (primarySite != null) {

                // doc 6 is required for the primary site
                if (documentTemplate.getName().startsWith("Research Protocol") && location.getId() == primarySite.getId()) {
                    return true;
                }

                // doc 7 is required for the primary site
                if (documentTemplate.getName().startsWith("Research Request Memo") && location.getId() == primarySite.getId()) {
                    return true;
                }

                // doc 8 is required for the primary site if the HIPAA patient consent is true
                if (documentTemplate.getName().startsWith("Sample Informed Consent") && location.getId() == primarySite.getId()
                        && dartRequest.isHipaaConsent()) {
                    return true;
                }

                // As per DUA document item 1.10, include DUA if transferredexternal = true
                // Data Use Agreement is required for the primary site
                if (documentTemplate.getName().startsWith("Data Use Agreement") && location.getId() == primarySite.getId()
                        && dartRequest.isTransferredExternal()) {
                    return true;
                }
            }
        } else if (isPreparatoryRequest(request)) {
            if (primarySite != null) {
                if (documentTemplate.getName().startsWith(PREPARATORY_TO_RESEARCH_MEMORANDUM)
                        && location.getId() == primarySite.getId()) {
                    return true;
                }
            }
        }

        return false;
    }

    @Override
    public boolean isRequired(Request request, DataSource dataSource, DocumentTemplate documentTemplate,
            Participant participant, final boolean isIndependentOnly) {

        if (documentTemplate.getName().startsWith("Vital Status Rules of Behavior") && participant.getDataAccess()) {
            return true;
        }

        Participant primarySitePrimaryInvestigator = getPrimarySitePrimaryInvestigator(request);
        if (primarySitePrimaryInvestigator != null) {

            if (documentTemplate.getName().startsWith("Vital Status Rules of Behavior")
                    && participant.getId() == primarySitePrimaryInvestigator.getId()) {
                return true;
            }

        }

        return false;
    }

    @Override
    public boolean isRequired(Request req, DataSource ds, DocumentTemplate temp, Group admin, Location site,
            final boolean isIndependentOnly) {
        return false;
    }

    @Override
    public boolean isRequired(Request req, DataSource ds, DocumentTemplate temp, Group admin, Participant participant,
            final boolean isIndependentOnly) {
        return false;
    }
}
